<?php

/* --------------------------------------------------------------
   InvoiceFileEntitler.inc.php 2024-09-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2024 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class InvoiceFileEntitler
 *
 * @category   System
 * @package    Invoice
 */
class InvoiceFileEntitler implements InvoiceFileEntitlerInterface
{
    /**
     * Creates a filename from an invoice id.
     *
     * @param IdType $invoiceId invoice_id of expected entry.
     *
     * @return string
     */
    public function createFilenameFromInvoiceId(IdType $invoiceId) : string
    {
        return $invoiceId->asInt() . '_' . md5(mt_rand(1, 10000)) . '.pdf';
    }
    
    /**
     * Creates a filename from a full path to a PDF file
     * The Type ExistingFilename prevents us from using not
     * available files
     *
     * @return string
     */
    public function createFilenameFromFullPathToFile(ExistingFile $fullPathToPdfFile) : string
    {
        return basename($fullPathToPdfFile->asString());
    }
}